
import React from 'react';
import type { RouteInput } from '../types';
import { TrashIcon } from './icons/TrashIcon';

interface RouteInputRowProps {
  route: RouteInput;
  onChange: (id: number, field: keyof Omit<RouteInput, 'id'>, value: string) => void;
  onRemove: (id: number) => void;
  isOnlyRow: boolean;
}

const RouteInputRow: React.FC<RouteInputRowProps> = ({ route, onChange, onRemove, isOnlyRow }) => {
  return (
    <div className="grid grid-cols-12 gap-2 items-center group">
      <div className="col-span-4">
        <input
          type="text"
          placeholder="e.g., Delhi"
          value={route.from}
          onChange={(e) => onChange(route.id, 'from', e.target.value)}
          className="w-full px-3 py-2 text-sm text-slate-700 bg-slate-50 border border-slate-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-shadow"
          aria-label="Starting location"
        />
      </div>
      <div className="col-span-4">
        <input
          type="text"
          placeholder="e.g., Mumbai"
          value={route.to}
          onChange={(e) => onChange(route.id, 'to', e.target.value)}
          className="w-full px-3 py-2 text-sm text-slate-700 bg-slate-50 border border-slate-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-shadow"
          aria-label="Destination"
        />
      </div>
       <div className="col-span-3">
        <input
          type="number"
          placeholder="e.g., 1420"
          value={route.actualDistance}
          onChange={(e) => onChange(route.id, 'actualDistance', e.target.value)}
          className="w-full px-3 py-2 text-sm text-slate-700 bg-slate-50 border border-slate-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-shadow"
          aria-label="Actual distance in kilometers"
          min="0"
        />
      </div>
      <div className="col-span-1 flex justify-end">
        <button
          onClick={() => onRemove(route.id)}
          disabled={isOnlyRow}
          className="p-2 text-slate-400 hover:text-red-600 hover:bg-red-100 rounded-full transition-colors duration-200 disabled:text-slate-300 disabled:hover:bg-transparent disabled:cursor-not-allowed"
          aria-label="Remove route"
        >
          <TrashIcon />
        </button>
      </div>
    </div>
  );
};

export default RouteInputRow;
