
import React from 'react';
import type { RouteInput } from '../types';
import RouteInputRow from './RouteInputRow';

interface RouteInputTableProps {
  routes: RouteInput[];
  onRouteChanage: (id: number, field: keyof Omit<RouteInput, 'id'>, value: string) => void;
  onRemoveRoute: (id: number) => void;
  onAddRoute: () => void;
}

const RouteInputTable: React.FC<RouteInputTableProps> = ({ routes, onRouteChanage, onRemoveRoute }) => {
  return (
    <div className="space-y-3">
        <div className="grid grid-cols-12 gap-2 text-sm font-semibold text-slate-500 px-2">
            <div className="col-span-4">From</div>
            <div className="col-span-4">To</div>
            <div className="col-span-3">Actual Distance (km)</div>
            <div className="col-span-1"></div>
        </div>
        {routes.map((route) => (
            <RouteInputRow
                key={route.id}
                route={route}
                onRemove={onRemoveRoute}
                onChange={onRouteChanage}
                isOnlyRow={routes.length === 1}
            />
        ))}
    </div>
  );
};

export default RouteInputTable;
