
export interface RouteInput {
  id: number;
  from: string;
  to: string;
  actualDistance: string; // Keep as string for input field value
}

// What the Gemini API is expected to return per route
export interface ApiRouteResult {
  from: string;
  to: string;
  totalDistance: string; // e.g., "1420 km"
  estimatedTime: string;
  routeSummary: string;
}

// The final data structure for display after calculations
export interface RouteResult extends ApiRouteResult {
  actualDistance: number;
  apiDistance: number;
  difference: number;
  deviation: number;
  samplingDecision: string;
}
