# ITR Tracker - Professional Tax Return Management System

A comprehensive, secure, and auditable web application for Indian CA firms to manage the entire lifecycle of Income Tax Return (ITR) filings. Built with modern technologies and designed for compliance with Indian regulations.

## 🚀 Features

### Core Functionality
- **Role-Based Access Control (RBAC)** - Partner, Manager, Staff, Client, and Auditor roles
- **Complete ITR Lifecycle Management** - 16-stage workflow from data request to closure
- **Document Management** - Upload, version control, and secure storage with checksums
- **Checklist Management** - ITR form-specific templates with progress tracking
- **Two-Level Review System** - Manager → Partner → Client approval workflow
- **E-Filing Integration** - Track acknowledgments, e-verification, and CPC processing
- **Comments & Mentions** - Collaborative communication with @mentions
- **Immutable Activity Log** - HMAC-signed audit trails for compliance
- **Dashboard & Analytics** - KPIs, SLA monitoring, and performance metrics
- **Evidence Pack Export** - ZIP archives for compliance reviews

### Compliance & Security
- **DPDP Act 2023** - Privacy-by-design with consent management
- **IT Act 2000 (Sec 65B)** - Evidentiary quality electronic records
- **ICAI Code of Ethics** - Professional confidentiality safeguards
- **Tamper-Evident Logging** - HMAC signatures for audit trail integrity
- **Data Masking** - PAN/Aadhaar masking in UI lists
- **Encrypted Storage** - Secure file storage with signed URLs
- **Rate Limiting** - API protection and abuse prevention

### Technical Features
- **Real-time Updates** - Live dashboard and status updates
- **CSV/Excel Import/Export** - Bulk operations and data portability
- **Reminder System** - Email/WhatsApp notifications with templates
- **SLA Management** - Configurable profiles with breach monitoring
- **Search & Filtering** - Advanced search across all entities
- **Responsive Design** - Mobile-friendly interface

## 🛠 Tech Stack

### Backend
- **FastAPI** - Modern Python web framework
- **SQLAlchemy + Alembic** - ORM and database migrations
- **PostgreSQL** - Production database (SQLite for development)
- **JWT Authentication** - Access/refresh token system
- **Argon2** - Password hashing
- **APScheduler** - Background task scheduling

### Frontend
- **React 18** - Modern UI library
- **TypeScript** - Type-safe development
- **Vite** - Fast build tool
- **TailwindCSS** - Utility-first styling
- **shadcn/ui** - High-quality components
- **React Query** - Data fetching and caching
- **React Hook Form** - Form management

### Development Tools
- **OpenAPI/Swagger** - Comprehensive API documentation
- **pytest** - Backend testing with >80% coverage
- **ESLint + Prettier** - Code quality and formatting
- **Pre-commit hooks** - Automated code checks

## 🚀 Quick Start

### Prerequisites
- Python 3.8+
- Node.js 16+
- PostgreSQL (for production)

### Installation

1. **Clone the repository**
   ```bash
   git clone <repository-url>
   cd itr-tracker
   ```

2. **Set up environment variables**
   ```bash
   cp .env.example .env
   # Edit .env with your configuration
   ```

3. **Install dependencies**
   ```bash
   # Backend dependencies
   pip install -r requirements.txt
   
   # Frontend dependencies
   npm install
   ```

4. **Database setup**
   ```bash
   # Run migrations
   npm run db:push
   
   # Seed demo data
   python scripts/seed_data.py
   ```

5. **Start the application**
   ```bash
   # Development mode (both frontend and backend)
   npm run dev
   
   # Or start services separately
   npm run dev:backend  # FastAPI on port 8000
   npm run dev:frontend # Vite on port 5173
   ```

6. **Access the application**
   - Frontend: http://localhost:5000
   - API Documentation: http://localhost:5000/docs
   - Health Check: http://localhost:5000/api/health

### Demo Credentials
