import { PRIORITY_LEVELS } from "@/lib/constants";

interface PriorityBadgeProps {
  priority: string;
  className?: string;
}

export default function PriorityBadge({ priority, className = "" }: PriorityBadgeProps) {
  const priorityKey = priority as keyof typeof PRIORITY_LEVELS;
  const displayName = PRIORITY_LEVELS[priorityKey] || priority;

  const getColorClass = (priority: string) => {
    switch (priority) {
      case "HIGH":
      case "CRITICAL":
        return "priority-high";
      case "MEDIUM":
        return "priority-medium";
      case "LOW":
        return "priority-low";
      default:
        return "text-gray-600";
    }
  };

  return (
    <span 
      className={`${getColorClass(priority)} ${className}`}
      data-testid={`priority-badge-${priority.toLowerCase()}`}
    >
      {displayName}
    </span>
  );
}
