import { ENGAGEMENT_STATUSES, STATUS_COLORS } from "@/lib/constants";

interface StatusChipProps {
  status: string;
  className?: string;
}

export default function StatusChip({ status, className = "" }: StatusChipProps) {
  const statusKey = status as keyof typeof ENGAGEMENT_STATUSES;
  const displayName = ENGAGEMENT_STATUSES[statusKey] || status;
  const color = STATUS_COLORS[statusKey] || "gray";

  const colorClasses = {
    gray: "bg-gray-100 text-gray-800",
    blue: "bg-blue-100 text-blue-800", 
    indigo: "bg-indigo-100 text-indigo-800",
    purple: "bg-purple-100 text-purple-800",
    yellow: "bg-yellow-100 text-yellow-800",
    orange: "bg-orange-100 text-orange-800",
    red: "bg-red-100 text-red-800",
    pink: "bg-pink-100 text-pink-800",
    green: "bg-green-100 text-green-800",
    emerald: "bg-emerald-100 text-emerald-800"
  };

  return (
    <span 
      className={`status-chip ${colorClasses[color]} ${className}`}
      data-testid={`status-chip-${status.toLowerCase()}`}
    >
      {displayName}
    </span>
  );
}
