import { useState } from "react";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Sheet, SheetContent, SheetHeader, SheetTitle, SheetTrigger } from "@/components/ui/sheet";
import { Badge } from "@/components/ui/badge";
import { Search, Bell, Plus } from "lucide-react";

export default function Header() {
  const [notifications, setNotifications] = useState([
    {
      id: 1,
      type: "sla_breach",
      title: "SLA Breach Alert",
      message: "Rajesh Kumar (ITR-2) has exceeded review deadline by 2 days",
      time: "2 hours ago",
      icon: "⚠️"
    },
    {
      id: 2,
      type: "comment",
      title: "New Comment",
      message: "You were mentioned in TechCorp Pvt Ltd computation notes",
      time: "4 hours ago",
      icon: "💬"
    },
    {
      id: 3,
      type: "filing",
      title: "Filing Completed",
      message: "Global Traders LLP ITR-5 successfully filed and e-verified",
      time: "6 hours ago",
      icon: "✅"
    }
  ]);

  return (
    <header className="bg-card border-b border-border px-6 py-4" data-testid="header">
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-xl font-semibold" data-testid="text-page-title">Dashboard</h2>
          <p className="text-sm text-muted-foreground">Assessment Year 2024-25 Overview</p>
        </div>
        
        <div className="flex items-center space-x-4">
          {/* Search */}
          <div className="relative">
            <Search className="absolute left-3 top-3 h-4 w-4 text-muted-foreground" />
            <Input
              type="search"
              placeholder="Search clients, PAN, engagements..."
              className="pl-10 w-80"
              data-testid="input-search"
            />
          </div>
          
          {/* Notifications */}
          <Sheet>
            <SheetTrigger asChild>
              <Button variant="ghost" size="icon" className="relative" data-testid="button-notifications">
                <Bell className="h-4 w-4" />
                {notifications.length > 0 && (
                  <Badge className="absolute -top-1 -right-1 h-5 w-5 rounded-full p-0 flex items-center justify-center text-xs">
                    {notifications.length}
                  </Badge>
                )}
              </Button>
            </SheetTrigger>
            <SheetContent>
              <SheetHeader>
                <SheetTitle>Notifications</SheetTitle>
              </SheetHeader>
              <div className="mt-4 space-y-4">
                {notifications.map((notification) => (
                  <div key={notification.id} className="border border-border rounded-lg p-3" data-testid={`notification-${notification.id}`}>
                    <div className="flex items-start space-x-3">
                      <div className="text-2xl">{notification.icon}</div>
                      <div className="flex-1">
                        <p className="text-sm font-medium" data-testid="text-notification-title">
                          {notification.title}
                        </p>
                        <p className="text-xs text-muted-foreground mb-2" data-testid="text-notification-message">
                          {notification.message}
                        </p>
                        <p className="text-xs text-muted-foreground" data-testid="text-notification-time">
                          {notification.time}
                        </p>
                      </div>
                    </div>
                  </div>
                ))}
              </div>
            </SheetContent>
          </Sheet>
          
          {/* New Engagement Button */}
          <Button data-testid="button-new-engagement">
            <Plus className="mr-2 h-4 w-4" />
            New Engagement
          </Button>
        </div>
      </div>
    </header>
  );
}
