export const ENGAGEMENT_STATUSES = {
  DATA_REQUESTED: "Data Requested",
  DATA_RECEIVED_PRELIMINARY: "Data Received",
  KYC_CONSENT_CAPTURED: "KYC/Consent Captured",
  DOC_INDEXING_VETTING: "Document Vetting",
  AIS_TIS_IMPORTED_RECONCILED: "AIS/TIS Reconciled",
  COMPUTATION_PREPARED: "Computation Prepared",
  MANAGER_REVIEW: "Manager Review",
  PARTNER_REVIEW: "Partner Review",
  CLIENT_REVIEW_SIGNOFF: "Client Sign-off",
  ITR_CREATED_JSON_VALIDATED: "ITR Created",
  ITR_FILED_ACK_CAPTURED: "ITR Filed",
  E_VERIFICATION_PENDING: "E-Verification Pending",
  E_VERIFICATION_DONE: "E-Verification Done",
  CPC_PROCESSING: "CPC Processing",
  REFUND_ADJUSTMENT_UPDATE: "Refund Update",
  CLOSED: "Closed"
} as const;

export const STATUS_COLORS = {
  DATA_REQUESTED: "gray",
  DATA_RECEIVED_PRELIMINARY: "blue",
  KYC_CONSENT_CAPTURED: "indigo",
  DOC_INDEXING_VETTING: "purple",
  AIS_TIS_IMPORTED_RECONCILED: "purple",
  COMPUTATION_PREPARED: "yellow",
  MANAGER_REVIEW: "orange",
  PARTNER_REVIEW: "red",
  CLIENT_REVIEW_SIGNOFF: "pink",
  ITR_CREATED_JSON_VALIDATED: "emerald",
  ITR_FILED_ACK_CAPTURED: "green",
  E_VERIFICATION_PENDING: "yellow",
  E_VERIFICATION_DONE: "green",
  CPC_PROCESSING: "blue",
  REFUND_ADJUSTMENT_UPDATE: "green",
  CLOSED: "emerald"
} as const;

export const PRIORITY_LEVELS = {
  LOW: "Low",
  MEDIUM: "Medium",
  HIGH: "High",
  CRITICAL: "Critical"
} as const;

export const ITR_FORM_TYPES = {
  "ITR-1": "ITR-1",
  "ITR-2": "ITR-2",
  "ITR-3": "ITR-3",
  "ITR-4": "ITR-4",
  "ITR-5": "ITR-5",
  "ITR-6": "ITR-6",
  "ITR-7": "ITR-7"
} as const;

export const USER_ROLES = {
  PARTNER: "Partner",
  MANAGER: "Manager",
  STAFF: "Staff",
  CLIENT: "Client",
  AUDITOR: "Auditor"
} as const;

export const TIER_TYPES = {
  INDIVIDUAL: "Individual",
  HUF: "HUF",
  FIRM: "Firm",
  COMPANY: "Company",
  TRUST: "Trust"
} as const;

export const CHECKLIST_STATUS = {
  PENDING: "Pending",
  IN_PROGRESS: "In Progress",
  DONE: "Done",
  NA: "N/A"
} as const;

export const ALLOWED_FILE_TYPES = [
  'application/pdf',
  'application/vnd.ms-excel',
  'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
  'text/csv',
  'image/jpeg',
  'image/png',
  'image/jpg'
];

export const MAX_FILE_SIZE = 10 * 1024 * 1024; // 10MB

export const DOCUMENT_TYPES = {
  FORM_16: "Form 16",
  AIS_26AS: "26AS/AIS",
  TIS: "TIS",
  BANK_STATEMENT: "Bank Statement",
  CAPITAL_GAINS: "Capital Gains",
  LOAN_INTEREST: "Loan Interest",
  DONATION: "Donation",
  HOUSE_PROPERTY: "House Property",
  BUSINESS: "Business",
  AUDIT_REPORT: "Audit Report 3CB-3CD",
  GENERAL: "General"
} as const;
