import type { 
  User, 
  Client, 
  Engagement, 
  Document, 
  Comment, 
  ChecklistItem, 
  Computation,
  ActivityLogEntry 
} from "@shared/schema";

export type { User, Client, Engagement, Document, Comment, ChecklistItem, Computation, ActivityLogEntry };

export interface EngagementWithClient extends Engagement {
  client: Client;
}

export interface CommentWithAuthor extends Comment {
  author: User;
}

export interface ActivityLogWithActor extends ActivityLogEntry {
  actor: User | null;
}

export interface DashboardStats {
  totalEngagements: number;
  pendingReviews: number;
  filedReturns: number;
  slaBreaches: number;
}

export interface PipelineStats {
  status: string;
  count: number;
}

export interface SearchFilters {
  q?: string;
  limit?: number;
  offset?: number;
  status?: string;
  priority?: string;
  assignee?: string;
  ay?: string;
}

export interface PaginatedResponse<T> {
  data: T[];
  total: number;
  limit: number;
  offset: number;
}

export interface FileUploadResponse {
  originalName: string;
  fileName: string;
  filePath: string;
  mimeType: string;
  size: number;
  checksum: string;
}

export interface StatusTransition {
  status: string;
  reason?: string;
}

export interface ReminderTemplate {
  key: string;
  name: string;
  subject: string;
  body: string;
  channel: 'EMAIL' | 'WHATSAPP' | 'SMS';
}
