import { useQuery } from "@tanstack/react-query";
import KPICards from "@/components/dashboard/kpi-cards";
import PipelineChart from "@/components/dashboard/pipeline-chart";
import RecentActivity from "@/components/dashboard/recent-activity";
import EngagementsTable from "@/components/tables/engagements-table";
import ReviewCard from "@/components/review/review-card";
import type { DashboardStats, PipelineStats, ActivityLogWithActor } from "@/lib/types";

export default function Dashboard() {
  const { data: stats, isLoading: statsLoading } = useQuery<DashboardStats>({
    queryKey: ["/api/dashboard/stats"],
  });

  const { data: pipeline, isLoading: pipelineLoading } = useQuery<PipelineStats[]>({
    queryKey: ["/api/dashboard/pipeline"],
  });

  const { data: activity, isLoading: activityLoading } = useQuery<ActivityLogWithActor[]>({
    queryKey: ["/api/dashboard/activity"],
  });

  // Mock review data - in a real app this would come from an API
  const reviewItems = [
    {
      id: "1",
      clientName: "Rajesh Kumar",
      details: "ITR-2 • AY 2024-25",
      stage: "Partner Review",
      preparer: "Ankit Patel",
      reviewer: "Priya Sharma",
      due: "Tomorrow"
    },
    {
      id: "2",
      clientName: "Sunita Agarwal",
      details: "ITR-1 • AY 2024-25",
      stage: "Manager Review",
      preparer: "Rohit Singh",
      reviewer: "You",
      due: "3 days"
    },
    {
      id: "3",
      clientName: "Global Traders LLP",
      details: "ITR-5 • AY 2024-25",
      stage: "Partner Review",
      preparer: "Kavya Nair",
      reviewer: "Priya Sharma",
      due: "Today"
    }
  ];

  return (
    <div className="p-6 space-y-8" data-testid="dashboard">
      {/* KPI Cards */}
      <KPICards stats={stats} isLoading={statsLoading} />

      {/* Pipeline and Activity */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <PipelineChart data={pipeline} isLoading={pipelineLoading} />
        <RecentActivity data={activity} isLoading={activityLoading} />
      </div>

      {/* Engagements Table */}
      <EngagementsTable />

      {/* Review Queue */}
      <div className="bg-card rounded-lg border border-border shadow-sm">
        <div className="border-b border-border p-6">
          <div className="flex items-center justify-between">
            <h3 className="text-lg font-semibold" data-testid="text-review-queue-title">Review Queue</h3>
            <div className="flex items-center space-x-2">
              <span className="text-sm text-muted-foreground">Role:</span>
              <span className="px-2 py-1 bg-primary text-primary-foreground rounded-md text-sm font-medium">
                Partner
              </span>
            </div>
          </div>
        </div>
        
        <div className="p-6">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            {reviewItems.map((item) => (
              <ReviewCard key={item.id} item={item} />
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}
