# ITR Tracker - Professional Tax Return Management System

## Overview

ITR Tracker is a comprehensive, secure, and auditable web application designed for Indian CA firms to manage the entire lifecycle of Income Tax Return (ITR) filings. The system provides a complete workflow management solution with role-based access control, document management, compliance tracking, and audit capabilities. Built with modern technologies and designed for regulatory compliance with Indian tax laws and data protection requirements.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
- **React 18** with TypeScript for type-safe development
- **Vite** as the build tool for fast development and optimized production builds
- **TailwindCSS** for utility-first styling with shadcn/ui component library
- **React Query** for server state management and data fetching
- **Wouter** for lightweight client-side routing
- **Component-based architecture** with reusable UI components organized by feature domains

### Backend Architecture
- **Node.js/Express** server with TypeScript for API development
- **JWT-based authentication** with access/refresh token pattern
- **Bcrypt** for secure password hashing
- **Role-Based Access Control (RBAC)** with granular permissions
- **RESTful API design** with OpenAPI/Swagger documentation
- **Middleware-based architecture** for authentication, validation, and error handling

### Database Layer
- **Drizzle ORM** with PostgreSQL schema definitions
- **Database migrations** managed through Drizzle Kit
- **Optimized for PostgreSQL** in production with SQLite fallback for development
- **Relational data model** with proper foreign key constraints and indexing

### Security Implementation
- **HMAC-signed activity logs** for tamper-evident audit trails
- **Input validation** using Zod schemas for type-safe data handling
- **Rate limiting** and CORS protection
- **File upload security** with type validation and size limits
- **Data masking** for sensitive information (PAN/Aadhaar) in UI
- **Signed URLs** for secure file downloads

### Workflow Engine
- **16-stage ITR lifecycle management** from data request to closure
- **State machine pattern** for status transitions with validation rules
- **Role-based approval workflows** (Staff → Manager → Partner → Client)
- **SLA monitoring** with configurable time limits and breach detection
- **Automated notifications** and reminder system

### File Management
- **Local file storage** with abstraction layer for cloud migration
- **Version control** and checksum validation for document integrity
- **Organized by engagement** with proper access controls
- **Metadata tracking** including upload timestamps and user attribution

### Compliance Features
- **Immutable audit logging** with cryptographic signatures
- **DPDP Act 2023 compliance** with privacy-by-design principles
- **IT Act 2000 compliance** for electronic record evidentiary quality
- **Data retention policies** with configurable retention periods
- **Export capabilities** for compliance reviews and evidence packs

## External Dependencies

### Core Dependencies
- **@neondatabase/serverless** - PostgreSQL database driver for serverless environments
- **drizzle-orm** - Type-safe ORM for database operations with PostgreSQL support
- **@tanstack/react-query** - Powerful data synchronization for React applications
- **@radix-ui components** - Accessible, unstyled UI primitives for building the design system
- **bcryptjs** - Password hashing library for secure authentication
- **jsonwebtoken** - JWT implementation for authentication tokens

### Development & Build Tools
- **Vite** - Fast build tool and development server
- **TypeScript** - Static type checking for JavaScript
- **TailwindCSS** - Utility-first CSS framework for styling
- **ESBuild** - Fast JavaScript bundler for production builds

### UI & Styling
- **class-variance-authority** - Utility for creating variant-based component APIs
- **clsx** - Utility for conditionally constructing className strings
- **tailwind-merge** - Utility for merging Tailwind CSS classes

### Form Handling & Validation
- **react-hook-form** - Performant forms library with minimal re-renders
- **@hookform/resolvers** - Validation resolvers for react-hook-form
- **zod** - Schema validation library for type-safe form validation

### Future Integrations
- **Email Services** - SMTP configuration for notification delivery
- **WhatsApp API** - Planned integration for client communication
- **Cloud Storage** - S3/Google Drive integration for file storage scalability
- **External APIs** - Income Tax Department APIs for e-filing integration