
import React from 'react';

const LoadingSpinner = ({ text }: { text?: string }) => (
  <div className="flex flex-col items-center justify-center space-y-2">
    <div className="animate-spin rounded-full h-12 w-12 border-b-2 border-pink-600"></div>
    {text && <p className="text-pink-600 font-medium">{text}</p>}
  </div>
);

export default LoadingSpinner;
