
import React from 'react';
import type { AppView } from '../../types';
import { HomeIcon, WardrobeIcon, TryOnIcon, ReportsIcon, PlusIcon } from '../common/Icons';

interface BottomNavProps {
  activeView: AppView;
  setView: (view: AppView) => void;
}

const NavItem: React.FC<{
  icon: React.ReactNode;
  label: string;
  isActive: boolean;
  onClick: () => void;
}> = ({ icon, label, isActive, onClick }) => (
  <button
    onClick={onClick}
    className={`flex flex-col items-center justify-center w-full pt-2 pb-1 transition-colors duration-200 ${
      isActive ? 'text-pink-600' : 'text-stone-500 hover:text-pink-500'
    }`}
  >
    {icon}
    <span className="text-xs mt-1">{label}</span>
  </button>
);

const BottomNav: React.FC<BottomNavProps> = ({ activeView, setView }) => {
  const navItems = [
    { view: 'DASHBOARD', label: 'Home', icon: <HomeIcon className="h-6 w-6" /> },
    { view: 'WARDROBE', label: 'Wardrobe', icon: <WardrobeIcon className="h-6 w-6" /> },
    { view: 'ADD_ITEM', label: 'Add', icon: null }, // Special case for central button
    { view: 'TRY_ON', label: 'Try-On', icon: <TryOnIcon className="h-6 w-6" /> },
    { view: 'REPORTS', label: 'Reports', icon: <ReportsIcon className="h-6 w-6" /> },
  ];

  return (
    <div className="fixed bottom-0 left-0 right-0 h-16 bg-white border-t border-stone-200 shadow-lg md:hidden">
      <div className="flex justify-around h-full">
        {navItems.map((item) => {
          if (item.view === 'ADD_ITEM') {
            return (
              <div key={item.view} className="w-1/5 flex justify-center">
                <button
                  onClick={() => setView('ADD_ITEM')}
                  className="-mt-6 bg-pink-600 text-white rounded-full h-16 w-16 flex items-center justify-center shadow-lg hover:bg-pink-700 transition-transform transform hover:scale-105"
                  aria-label="Add new item"
                >
                  <PlusIcon className="h-8 w-8" />
                </button>
              </div>
            );
          }
          return (
            <div key={item.view} className="w-1/5">
              <NavItem
                icon={item.icon}
                label={item.label}
                isActive={activeView === item.view}
                onClick={() => setView(item.view as AppView)}
              />
            </div>
          );
        })}
      </div>
    </div>
  );
};

export default BottomNav;
