export enum GarmentCategory {
  TOP = 'Top',
  BOTTOM = 'Bottom',
  DRESS = 'Dress',
  OUTERWEAR = 'Outerwear',
  ACCESSORY = 'Accessory',
  SHOES = 'Shoes',
  UNKNOWN = 'Unknown',
}

export interface Garment {
  id: string;
  name: string;
  category: GarmentCategory;
  brand: string;
  size: string;
  color: string;
  price: number;
  purchaseDate: string;
  tags: string[];
  frontImageUrl: string;
  backImageUrl?: string;
  careInstructions: string;
}

export interface WearEvent {
  id: string;
  garmentIds: string[];
  date: string;
  occasion: string;
  notes: string;
  photoUrl?: string;
}

export interface AvatarProfile {
  frontPhoto: string; // base64
  sidePhoto: string; // base64
  avatarUrl: string; // placeholder URL
}

export type AppView = 'ONBOARDING' | 'DASHBOARD' | 'WARDROBE' | 'TRY_ON' | 'ADD_ITEM' | 'REPORTS' | 'LOG_WEAR' | 'TRAVEL_PLANNER';